<?php
session_start();

include('db.php'); // Include database connection

// Check if the user is logged in
$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.'
    ]);
    exit;
}

// Get JSON data
$data = json_decode(file_get_contents('php://input'), true);

// Validate input data
if (empty($data['Products']) || !isset($data['Shipping'], $data['Roundoff'], $data['Discount_percentage'], $data['Balance'], $data['paymentid'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid input data.'
    ]);
    exit;
}

// Assign input data to variables
$customerid = $data['customerid'];
$shipping = (float)($data['Shipping'] ?? 0);
$roundoff = (float)($data['Roundoff'] ?? 0);
$discount_percentage = (float)$data['Discount_percentage'];
$balance = (float)$data['Balance'];
$products = $data['Products'];

$product_total = $tax_total = $discount_total = $total_savings = 0;

// Validate customer
$user_query = "SELECT displayname FROM customer WHERE id= '$customerid' AND delete_status = 0";
$user_result = mysqli_query($conn, $user_query);

if (!$user_result || mysqli_num_rows($user_result) == 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Customer not found or inactive.'
    ]);
    exit;
}

$user_data = mysqli_fetch_assoc($user_result);
$displayname = $user_data['displayname'];

// Process each product
foreach ($products as $product) {
    if (!isset($product['Product_id'], $product['Selling_price'], $product['Tax_percentage'], $product['Qty'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid product data.'
        ]);
        exit;
    }

    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];

    $product_query = "SELECT Product_name, MRP, qty, sale_price_tax  FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result = mysqli_query($conn, $product_query);

    if (!$product_result || mysqli_num_rows($product_result) == 0) {
        echo json_encode([
            'status' => 'error',
            'message' => "Product ID $product_id not found or inactive."
        ]);
        exit;
    }

    $product_data = mysqli_fetch_assoc($product_result);
    if ($product_data['qty'] < $qty) {
        echo json_encode([
            'status' => 'error',
            'message' => "Insufficient stock for Product ID $product_id."
        ]);
        exit;
    }
    
$mrp = (float)$product_data['MRP'];
$sale_price_tax = (int)$product_data['sale_price_tax'];

// Calculate values
$discount = ($selling_price * $discount_percentage) / 100;
$product_subtotal = $selling_price * $qty;
$tax = 0;

if ($sale_price_tax == 2) {
    // Only calculate tax if sale_price_tax is 2
    $tax = ($product_subtotal * $tax_percentage) / 100;
}

$product_total += $product_subtotal;
$tax_total += $tax;
$discount_total += $discount * $qty;
$total_savings += ($mrp - $selling_price) * $qty;
}

$grand_total = $product_total + $tax_total + $shipping - $roundoff;
$grand_total1 = number_format((float)$grand_total, 2, '.', '');

// Insert into `invoice`
$created_date = date('Y-m-d H:i:s');
$paymentid = $data['paymentid'];
$due_date = $data['duedate'];
$payment_status = ($balance == 0) ? 1 : (($balance < $grand_total) ? 2 : 0);

$invoice_query = "
    INSERT INTO invoice (
        user_id, displayname, Created_date, Due_date, Balance, 
        Tax,Tax_percentage, Discount, Discount_percentage, Shipping, Roundoff, 
        Total_price, Grand_total, No_of_items, Created_id, Editor_id, 
        Delete_status, Total_saving, Total_discount, Payment_status, Action_status, Store_status,Payment_id
    ) VALUES (
        '$customerid', '$displayname', '$created_date', '$due_date', '$balance',
        '$tax_total', '$tax_percentage', '$discount_total', '$discount_percentage', '$shipping', '$roundoff',
        '$product_total', '$grand_total1', '" . count($products) . "',
        '$user_id', '$user_id', 0, '$total_savings', '$discount_total',
        '$payment_status', 1, 0,'$paymentid'
    )";

if (!mysqli_query($conn, $invoice_query)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to create invoice.',
        'error' => mysqli_error($conn)
    ]);
    exit;
}

$invoice_id = mysqli_insert_id($conn);
$formatted_invoice_no = 'INV-' . str_pad($invoice_id, 4, '0', STR_PAD_LEFT);
mysqli_query($conn, "UPDATE invoice SET invoice_no = '$formatted_invoice_no' WHERE invoice_id = '$invoice_id'");

// Insert products into `invoice_data`
foreach ($products as $product) {
    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);

    $product_query2 = "SELECT  MRP,  sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
$product_result2 = mysqli_query($conn, $product_query2);

$product_data2 = mysqli_fetch_assoc($product_result2);

    $selling_price = (float)$product['Selling_price'];
    $MRP = (float)$product_data2['MRP'];
    $Sale_Price_Tax= $product_data2['sale_price_tax'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];
    $discount_percentage1 = (float)$product['discount_Percentage'];

    $discount = ($selling_price * $discount_percentage1) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = ($product_subtotal * $tax_percentage) / 100;

    $invoice_data_query = "
        INSERT INTO invoice_data (
            Invoice_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
            Tax_percentage, Tax,salepricetax,  Product_total, Delete_status
        ) VALUES (
            '$invoice_id', '$product_id', '$qty', '$selling_price', '$MRP', '$discount', 
            '$discount_percentage1', '$tax_percentage', '$tax','$Sale_Price_Tax', '$product_subtotal', 0
        )";

    mysqli_query($conn, $invoice_data_query);

    // Update product stock
    $update_product_query = "
        UPDATE product 
        SET qty = qty - '$qty' 
        WHERE Product_id = '$product_id'";
    mysqli_query($conn, $update_product_query);
    $update_inventory_query = "UPDATE inventory  
    SET Qty = Qty - '$qty',
    date_modified = NOW()
    WHERE Product_id = '$product_id'";

mysqli_query($conn, $update_inventory_query);
}



if ($invoice_id) {

    // Fetch profile information

    $querys = mysqli_query($conn, "SELECT * FROM user_profile WHERE User_id=4");

    if (!$querys) {

        die('Error fetching profile data: ' . mysqli_error($conn));

    }

    $profileselect = mysqli_fetch_array($querys);



    // Assign profile data to variables with default values

    $storename = $profileselect['store_name'] ?? 'Default Store Name';

    $email = $profileselect['Email'] ?? 'no-reply@example.com'; 

    $street1 = $profileselect['Address'] ?? '';

    $street2 = $profileselect['street2']??'';

    $city = $profileselect['City'] ?? '';

    $state = $profileselect['State'] ?? '';

    $pincode = $profileselect['Pincode'] ?? '';

    $phonenumber = $profileselect['Phone'] ?? '';

    $gstno = $profileselect['gstin'] ?? '';

    $logopath = $profileselect['store_image'] ?? '';

    $accountno = $profileselect['acount_no'] ?? '';

    $ifsc = $profileselect['ifsc'] ?? '';

    $bank = $profileselect['bank_name'] ?? '';

    $upiid = $profileselect['upiid'] ?? '';



    // Fetch invoice information

    $query = mysqli_query($conn, "SELECT i.invoice_id, i.invoice_no, i.Created_date, i.Grand_total, c.displayname, c.phoneno, c.address, c.city, c.pincode, c.gstno, c.email, i.order_id, i.user_id

                                        FROM invoice i 

                                        INNER JOIN customer c ON c.id = i.user_id 

                                        WHERE i.invoice_id = '$invoice_id'");

    if (!$query) {

        die('Error fetching invoice data: ' . mysqli_error($conn));

    }

    $invoice = mysqli_fetch_array($query);

    $grandtotal11 = $invoice['Grand_total'];
    $invoice_data = $invoice['Create_date'];



    // Fetch invoice settings

    $query1 = mysqli_query($conn, "SELECT * FROM invoicesetting WHERE 1");

    if (!$query1) {

        die('Error fetching invoice settings: ' . mysqli_error($conn));

    }

    $terms = mysqli_fetch_array($query1);



$sqlInsert = "INSERT INTO invoicepdfdetails 

(invoiceno,invoiceid,customerid,totalsavings, grandtotal, storename, email, street1,street2, city, state, pincode, phonenumber, gstnumber, logopath, notes, account, ifsc, bankname, displayname, phoneno, address, customer_city, customer_pincode, customer_gstno, customer_email,upiid, terms, qrcode) 

VALUES 

('$formatted_invoice_no', '$invoice_id',  '$customerid','$total_savings','$grandtotal11', '$storename', '$email', '$street1','$street2', '$city', '$state', '$pincode', '$phonenumber', '$gstno', '$logopath', '".$terms['note']."', '$accountno', '$ifsc', '$bank', '".$invoice['displayname']."', '".$invoice['phoneno']."', '".$invoice['address']."', '".$invoice['city']."', '".$invoice['pincode']."', '".$invoice['gstno']."', '".$invoice['email']."','$upiid', '".$terms['terms']."', '".$terms['qrcode']."')";



if (!mysqli_query($conn, $sqlInsert)) {

die('Error inserting invoice PDF details: ' . mysqli_error($conn));

} else {

//echo "Data inserted successfully!";

}
}

// Return success response
echo json_encode([
    'status' => 'success',
    'message' => 'Order and invoice created successfully.',
    'invoice_id' => $invoice_id,
    'invoice_no' => $formatted_invoice_no,
    'grand_total' => $grand_total
]);
?>
